<?php

require '../config/sessionToken.php'; // Ensure the correct path for your session token
require_once '../config/constants.php'; // Constants for status codes/messages

function validateSessionToken() {
    $sessionToken = $_COOKIE['session_token'] ?? '';

    if (empty($sessionToken)) {
        echo json_encode([
            'status' => FAILED,
            'message' => MISSING_SESSION_TOKEN,
            'responseCode' => MISSING_SESSION_TOKEN_AUTH
        ]);
        exit();
    }

    $isValid = Token::Verify($sessionToken, APP_KEY);
    $isValidResponse = json_decode($isValid, true);

    if ($isValidResponse['headers']['status'] !== 'success') {
        echo json_encode([
            'status' => FAILED,
            'message' => SESSION_TIME_EXCEEDED_MSG,
            'responseCode' => SESSION_TIME_EXCEEDED
        ]);
        exit();
    }

    return $sessionToken;
}

function generateOtp() {
    return random_int(100000, 999999);
}

function sendOtp($mobile, $otp) {
    $apiKey = "14f7a9ae-9a61-11ef-8b17-0200cd936042"; // Replace with your actual API key
    $url = "https://2factor.in/API/V1/$apiKey/SMS/$mobile/$otp/OTP1";

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    curl_close($ch);

    return json_decode($response, true);
}

function resendOtpHandler($pdo) {
    $sessionToken = validateSessionToken();

    $input = json_decode(file_get_contents('php://input'), true);
    $mobile = $input['mobile'] ?? '';
    $locale = $input['locale'] ?? 'en';

if ($locale === 'bn') {
    require_once '../config/app_bn.php';
} else {
    require_once '../config/app_en.php';
}


    if (empty($mobile)) {
        echo json_encode([
            'status' => FAILED,
            'message' => MOBILE_NUMBER_REQUIRED,
            'responseCode' => MOBILE_NUMBER_REQUIRED_CODE
        ]);
        return;
    }

    // Check for existing OTP requests
    $stmt = $pdo->prepare("SELECT * FROM otp_requests WHERE mobile = :mobile AND session_token = :session_token");
    $stmt->execute(['mobile' => $mobile, 'session_token' => $sessionToken]);
    $otpRequest = $stmt->fetch();

    if (!$otpRequest) {
        echo json_encode([
            'status' => FAILED,
            'message' => NO_OTP_REQUEST_FOUND,
            'responseCode' => NO_OTP_REQUEST_FOUND_CODE
        ]);
        return;
    }

    // Check if attempts exceed the limit
    if ($otpRequest['attempts'] >= 4) {
        echo json_encode([
            'status' => FAILED,
            'message' => OTP_LIMIT_EXAUSTED,
            'responseCode' => OTP_LIMIT_EXAUSTED_CODE
        ]);
        return;
    }

    // Generate a new OTP
    $otp = generateOtp();
    $response = sendOtp($mobile, $otp);

    if (isset($response['Status']) && $response['Status'] === 'Success') {
        // Update OTP request
        $stmt = $pdo->prepare("UPDATE otp_requests SET otp = :otp, attempts = attempts + 1, created_at = NOW() WHERE mobile = :mobile AND session_token = :session_token");
        $stmt->execute([
            'otp' => $otp,
            'mobile' => $mobile,
            'session_token' => $sessionToken
        ]);

        echo json_encode([
            'status' => SUCCESS,
            'message' => OTP_SENT_SUCCESSFULLY,
            'responseCode' => OTP_SENT_CODE
        ]);
    } else {
        echo json_encode([
            'status' => FAILED,
            'message' => OTP_SENT_FAILED,
            'responseCode' => OTP_SENT_FAILED_CODE,
        ]);
    }
}

// Call the resend OTP handler
resendOtpHandler($pdo);
?>
