<?php
require '../config/sessionToken.php'; // Assuming this has the logic to verify session tokens
require_once '../config/constants.php';

// Function to get questions based on filters
function getQuestions($data, $pdo) {
    $sessionToken = $_COOKIE['session_token'] ?? '';

    // Verify the session token
    $isValid = Token::Verify($sessionToken, APP_KEY);
    $isValidResponse = json_decode($isValid, true);
    if ($isValidResponse['headers']['status'] == 'failed') {
        return json_encode($isValidResponse);
    }

    // Check if mandatory fields are provided
    if (empty($data['class_name']) || empty($data['subject_name'])) {
        return json_encode([
            'headers' => [
                'status' => FAILED,
                'responseCode' => MISSING_REQUIRED_FIELDS,
                'message' => MISSING_REQUIRED_FIELDS_TEXT
            ]
        ]);
    }

    // Start building the query
    $query = "SELECT * FROM questions WHERE class_name = :class_name AND subject_name = :subject_name";
    $params = [
        ':class_name' => $data['class_name'],
        ':subject_name' => $data['subject_name']
    ];

    // Check if chapter_name is provided
    if (!empty($data['chapter_name'])) {
        $query .= " AND chapter_name = :chapter_name";
        $params[':chapter_name'] = $data['chapter_name'];
    }

    // Check if question_type is provided
    if (!empty($data['question_type'])) {
        $query .= " AND question_type = :question_type";
        $params[':question_type'] = $data['question_type'];
    }

    // Check if unit_test is provided
    if (!empty($data['unit_test'])) {
        $query .= " AND unit_test = :unit_test";
        $params[':unit_test'] = $data['unit_test'];
    }

    // Check if marks is provided
    if (!empty($data['marks'])) {
        $query .= " AND marks = :marks";
        $params[':marks'] = $data['marks'];
    }

    // Check if addedBy is provided
    if (!empty($data['addedBy'])) {
        $query .= " AND addedBy = :addedBy";
        $params[':addedBy'] = $data['addedBy'];
    }

    // Check if question_status is provided
    if (!empty($data['question_status'])) {
        $query .= " AND question_status = :question_status";
        $params[':question_status'] = $data['question_status'];
    }

    // Prepare the SQL statement
    $stmt = $pdo->prepare($query);

    // Bind parameters
    foreach ($params as $key => &$val) {
        $stmt->bindParam($key, $val);
    }

    // Execute the query
    $stmt->execute();

    // Fetch all matching questions
    $questions = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Return response
    return json_encode([
        'headers' => [
            'status' => SUCCESS,
            'responseCode' => COMMON_SUCCESS,
            'message' => QUESTION_RETERIVED_SUCCESS,
        ],
        'data' => $questions
    ]);
}

// Get input data from the POST request
$input = json_decode(file_get_contents('php://input'), true);

$locale = $input['locale'] ?? 'en';


    if ($locale === 'bn') {
        require_once '../config/app_bn.php';
    } else {
        require_once '../config/app_en.php';
    }

// If no data is provided, return an error
if (empty($input)) {
    echo json_encode([
        'headers' => [
            'status' => FAILED,
            'responseCode' => MISSING_REQUIRED_FIELDS,
            'message' => MISSING_REQUIRED_FIELDS_TEXT,
        ]
    ]);
    exit();
}

// Call the function to get questions
echo getQuestions($input, $pdo);
?>
