<?php

require 'config/sessionToken.php';
require_once 'config/constants.php';


function checkMobileAvailabilityHandler($pdo) {
    $input = json_decode(file_get_contents('php://input'), true);
    $mobileNumber = $input['mobile_number'] ?? '';
    $locale = $input['locale'] ?? 'en';


    if ($locale === 'bn') {
        require_once 'config/app_bn.php';
    } else {
        require_once 'config/app_en.php';
    }

    if (empty($mobileNumber)) {
        echo json_encode(
            [
                "headers"=>[
                    'status' => FAILED,
                    'message' => MOBILE_NUMBER_REQUIRED,
                    'responseCode' => MOBILE_NUMBER_REQUIRED_CODE
                ],
        ]);
        return;
    }


     // Check if the mobile number exists in the students table
     $stmt = $pdo->prepare("SELECT id, first_name, last_name, mobile_number, class, school_name, city, is_premium_user FROM students WHERE mobile_number = :mobile_number");
     $stmt->execute(['mobile_number' => $mobileNumber]);
     $student = $stmt->fetch(PDO::FETCH_ASSOC);
 
     if ($student) {
         echo json_encode([
             'headers' => [
                'status' => SUCCESS,
                'message' => MOBNO_ALREADY_EXISTS,
                'responseCode' => MOBNO_ALREADY_EXISTS_CODE
            ],
             'body' =>[
                'available' => true,
            ]
         ]);
         return;
     }


     // Check if the mobile number exists in the teachers table
    $stmt = $pdo->prepare("SELECT id, first_name, last_name, email, mobile_number, class, school_name, subject, teacher_request FROM teachers WHERE mobile_number = :mobile_number");
    $stmt->execute(['mobile_number' => $mobileNumber]);
    $teacher = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($teacher) {
        echo json_encode([
           'headers' => [
                'status' => SUCCESS,
                'message' => MOBNO_ALREADY_EXISTS,
                'responseCode' => MOBNO_ALREADY_EXISTS_CODE
            ],
            'body' => [
                'available' => true,
            ]
        ]);
        return;
    }


    echo json_encode([

        'headers' => [
            'status' => SUCCESS,
            'message' => MOBNO_NOTFOUND,
            'responseCode' => MOBNO_NOTFOUND_CODE
        ],
        'body' =>[
            'available' => false,
        ]
    ]);
}

// Call the mobile number availability handler
checkMobileAvailabilityHandler($pdo);
?>