<?php

require 'config/sessionToken.php'; // Ensure the correct path for your session token
require_once 'config/constants.php'; // Constants for status codes/messages

function loginUserHandler($pdo) {
    $sessionToken = $_COOKIE['session_token'] ?? '';

    // Verify the session token
    $isValid = Token::Verify($sessionToken, APP_KEY);
    $isValidResponse = json_decode($isValid, true);
    if ($isValidResponse['headers']['status'] == FAILED) {
        return json_encode($isValidResponse);
    }

        
    $input = json_decode(file_get_contents('php://input'), true);
    $mobileNumber = $input['mobile_number'] ?? '';
    $locale = $input['locale'] ?? 'en';

    if ($locale === 'bn') {
        require_once 'config/app_bn.php';
    } else {
        require_once 'config/app_en.php';
    }

    if (empty($mobileNumber)) {
        echo json_encode([
            "headers" => [
                'status' => FAILED,
                'message' => MOBILE_NUMBER_REQUIRED,
                'responseCode' => MOBILE_NUMBER_REQUIRED_CODE
            ]
        ]);
        return;
    }

    // Check if the mobile number exists in the students table
    $stmt = $pdo->prepare("SELECT id, first_name, last_name, mobile_number, class, school_name, city, is_premium_user FROM students WHERE mobile_number = :mobile_number");
    $stmt->execute(['mobile_number' => $mobileNumber]);
    $student = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($student) {
        echo json_encode([
            'headers' => [
                'status' => SUCCESS,
                'message' => USER_FOUND_IN_STUDNTS_TABLE,
                'responseCode' => COMMON_SUCCESS
            ],
            'body' => [
                'user_type' => 'student',
                'user_details' => $student
            ]
        ]);
        return;
    }

    // Check if the mobile number exists in the teachers table
    $stmt = $pdo->prepare("SELECT id, first_name, last_name, email, mobile_number, class, school_name, subject, teacher_request FROM teachers WHERE mobile_number = :mobile_number");
    $stmt->execute(['mobile_number' => $mobileNumber]);
    $teacher = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($teacher) {
        echo json_encode([
            'headers' => [
                'status' => SUCCESS,
                'message' => USER_FOUND_IN_TEACHERS_TABLE,
                'responseCode' => COMMON_SUCCESS
            ],
            'body' => [
                'user_type' => 'teacher',
                'user_details' => $teacher
            ]
        ]);
        return;
    }

    // If the user was not found in either table
    echo json_encode([
        'headers' => [
            'status' => FAILED,
            'message' => MOBNO_NOTFOUND,
            'responseCode' => MOBNO_NOTFOUND_CODE
        ]
    ]);
}

// Call the loginUser handler
loginUserHandler($pdo);
?>
