<?php

require '../config/sessionToken.php'; // Ensure the correct path for your session token
require_once '../config/constants.php'; // Constants for status codes/messages

function registerStudentHandler($pdo) {
    $sessionToken = $_COOKIE['session_token'] ?? '';

    // Verify the session token
    $isValid = Token::Verify($sessionToken, APP_KEY);
    $isValidResponse = json_decode($isValid, true);
    if ($isValidResponse['headers']['status'] == FAILED) {
        return json_encode($isValidResponse);
    }

    $input = json_decode(file_get_contents('php://input'), true);
    $locale = $input['locale'] ?? 'en';


    if ($locale === 'bn') {
        require_once '../config/app_bn.php';
    } else {
        require_once '../config/app_en.php';
    }
    $requiredFields = ['first_name', 'last_name', 'mobile_number', 'class', 'school_name', 'city', 'is_premium_user'];
    
    // Validate all required fields are present
    foreach ($requiredFields as $field) {
        if (empty($input[$field])) {
            echo json_encode([
                "headers" => [
                    'status' => FAILED,
                    'message' => MISSING_REQUIRED_FIELDS_TEXT,
                    'responseCode' => MISSING_REQUIRED_FIELDS
                ]
            ]);
            return;
        }
    }

    $firstName = $input['first_name'];
    $lastName = $input['last_name'];
    $mobileNumber = $input['mobile_number'];
    $class = $input['class'];
    $schoolName = $input['school_name'];
    $city = $input['city'];
    $isPremiumUser = $input['is_premium_user'];

    // Check if the mobile number already exists in the students table
    $stmt = $pdo->prepare("SELECT 1 FROM students WHERE mobile_number = :mobile_number");
    $stmt->execute(['mobile_number' => $mobileNumber]);
    $studentExists = $stmt->fetch();

    if ($studentExists) {
        echo json_encode([
            'headers' => [
                'status' => FAILED,
                'message' => MOBNO_ALREADY_EXISTS,
                'responseCode' => MOBNO_ALREADY_EXISTS_CODE
            ]
        ]);
        return;
    }

    // Insert the new student into the students table
    $stmt = $pdo->prepare("INSERT INTO students (first_name, last_name, mobile_number, class, school_name, city, is_premium_user) VALUES (:first_name, :last_name, :mobile_number, :class, :school_name, :city, :is_premium_user)");
    
    $stmt->execute([
        'first_name' => $firstName,
        'last_name' => $lastName,
        'mobile_number' => $mobileNumber,
        'class' => $class,
        'school_name' => $schoolName,
        'city' => $city,
        'is_premium_user' => $isPremiumUser
    ]);

    echo json_encode([
        'headers' => [
            'status' => SUCCESS,
            'message' => STUDENT_REGISTERED_SUCCESS,
            'responseCode' => STUDENT_REGISTERED_SUCCESS_CODE
        ]
    ]);
}

// Call the student registration handler
registerStudentHandler($pdo);
?>
