<?php
require '../config/sessionToken.php'; // Assuming this has the logic to verify session tokens
require_once '../config/constants.php';


// Function to add a new teacher
function addTeacher($data, $pdo) {
    // Use getAllHeaders() to fetch headers, including session token
    $sessionToken = $_COOKIE['session_token'] ?? '';

    if (empty($sessionToken)) {
        return json_encode([
            'headers' => [
                'status' => FAILED,
                'responseCode' => MISSING_SESSION_TOKEN_AUTH,
                'message' => MISSING_SESSION_TOKEN
            ]
        ]);
    }

    // Verify the session token


    $isValid = Token::Verify($sessionToken, APP_KEY);
    // $isValid  = json_decode($isValid,true);
    $isValidResponse = json_decode($isValid, true);
    if($isValidResponse['headers']['status'] == FAILED){
        return json_encode(
            $isValidResponse,
        );
    }

    // Check if the required fields are set
    $requiredFields = ['first_name', 'last_name', 'email', 'mobile_number', 'class', 'school_name', 'subject', 'teacher_request'];
    
    foreach ($requiredFields as $field) {
        if (empty($data[$field])) {
            return json_encode([
                'headers' => [
                    'status' => FAILED,
                    'responseCode' => MISSING_REQUIRED_FIELDS,
                    'message' => MISSING_REQUIRED_FIELDS_TEXT
                ],
            ]);
        }
    }

    // Check if mobile number or email already exists
    $stmt = $pdo->prepare("SELECT id FROM teachers WHERE email = :email OR mobile_number = :mobile_number");
    $stmt->execute(['email' => $data['email'], 'mobile_number' => $data['mobile_number']]);
    $existingTeacher = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($existingTeacher) {
        return json_encode([
            'headers' => [
                'status' => FAILED,
                'responseCode' => TEACHER_EMAIL_MOB_EXISTS_CODE,
                'message' => TEACHER_EMAIL_MOB_EXISTS
            ]
        ]);
    }

    // Prepare SQL for inserting new teacher
    $stmt = $pdo->prepare("
        INSERT INTO teachers (first_name, last_name, email, mobile_number, class, school_name, subject, teacher_request, approved_on)
        VALUES (:first_name, :last_name, :email, :mobile_number, :class, :school_name, :subject, :teacher_request, :approved_on)
    ");

    $approved_on = date('Y:m:d H:i:s');;
    $teacher_request = strtolower($data['teacher_request']);


    // Bind parameters
    $stmt->bindParam(':first_name', $data['first_name']);
    $stmt->bindParam(':last_name', $data['last_name']);
    $stmt->bindParam(':email', $data['email']);
    $stmt->bindParam(':mobile_number', $data['mobile_number']);
    $stmt->bindParam(':class', $data['class']);
    $stmt->bindParam(':school_name', $data['school_name']);
    $stmt->bindParam(':subject', $data['subject']);
    $stmt->bindParam(':teacher_request', $teacher_request);
    $stmt->bindParam(':approved_on', $approved_on); 

    // Execute and check for errors
    if ($stmt->execute()) {
        return json_encode([
            'headers' => [
                'status' => SUCCESS,
                'responseCode' => TEACHER_REGISTERED_SUCCESS_CODE,
                'message' => TEACHER_REGISTERED_SUCCESS
            ],
            'body' => [
                'teacher_id' => $pdo->lastInsertId(),
                'teacher_status' => TEACHER_REGISTERED_SUCCESS
            ]
        ]);
    } else {
        return json_encode([
            'headers' => [
                'status' => FAILED,
                'responseCode' => STUDENT_REGISTERED_FAILED_CODE,
                'message' => TEACHER_REG_FAILED
            ]
        ]);
    }
}

// Get input data from the POST request
$input = json_decode(file_get_contents('php://input'), true);

$locale = $input['locale'] ?? 'en';


    if ($locale === 'bn') {
        require_once '../config/app_bn.php';
    } else {
        require_once '../config/app_en.php';
    }

// If no data is provided, return an error
if (empty($input)) {
    echo json_encode([
        'headers' => [
            'status' => FAILED,
            'responseCode' => MISSING_REQUIRED_FIELDS,
            'message' => MISSING_REQUIRED_FIELDS_TEXT,
        ]
    ]);
    exit();
}

// Call the function to add a teacher
echo addTeacher($input, $pdo);
?>